/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.method.service.impl;

import agrota.backagrota.logic.method.model.KeycloakTokenResponse;
import agrota.backagrota.logic.method.service.KeycloakService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

@Service
public class KeycloakServiceImpl
implements KeycloakService {
    private static final Logger log = LoggerFactory.getLogger(KeycloakServiceImpl.class);
    private final WebClient.Builder webClientBuilder;
    private final Environment env;

    public Mono<KeycloakTokenResponse> login(String username, String password) {
        return this.getToken(username, password);
    }

    public Mono<KeycloakTokenResponse> login() {
        return this.getToken();
    }

    public Mono<KeycloakTokenResponse> getToken() {
        String username = this.env.getProperty("keycloak.username");
        String password = this.env.getProperty("keycloak.password");
        return this.getToken(username, password);
    }

    public Mono<KeycloakTokenResponse> getToken(String username, String password) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"client_id", (Object)this.env.getProperty("jwt.client-id"));
        formData.add((Object)"grant_type", (Object)"password");
        formData.add((Object)"username", (Object)username);
        formData.add((Object)"password", (Object)password);
        return ((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(this.env.getProperty("keycloak.token.url"), new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)formData)).retrieve().bodyToMono(KeycloakTokenResponse.class).doOnError(e -> {
            log.error("\u274c Error getting token from Keycloak: {}", (Object)e.getMessage());
            if (e instanceof WebClientResponseException) {
                WebClientResponseException ex = (WebClientResponseException)e;
                log.error("\ud83d\udccc Keycloak Response Body: {}", (Object)ex.getResponseBodyAsString());
            }
        });
    }

    @Generated
    public KeycloakServiceImpl(WebClient.Builder webClientBuilder, Environment env) {
        this.webClientBuilder = webClientBuilder;
        this.env = env;
    }
}

