/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.method.service.impl;

import agrota.backagrota.logic.method.model.AuditLog;
import agrota.backagrota.logic.method.repository.AuditRepository;
import agrota.backagrota.logic.method.service.AuditService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditServiceImpl
implements AuditService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditServiceImpl.class);
    private final AuditRepository auditRepository;

    public void logRequest(HttpServletRequest request, Object handler) {
        log.info("Request: {} {}", (Object)request.getMethod(), (Object)request.getRequestURI());
    }

    public void logResponse(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (ex != null) {
            log.error("Response Error: {} {} - Status: {} - Error: {}", new Object[]{request.getMethod(), request.getRequestURI(), response.getStatus(), ex.getMessage()});
        } else {
            log.info("Response: {} {} - Status: {}", new Object[]{request.getMethod(), request.getRequestURI(), response.getStatus()});
        }
    }

    @Transactional
    public void log(String action, String category, String target, String user, String details, String requestType, Object payload) {
        log.info("Audit [{}]: Action={}, Target={}, User={}, Details={}, Type={}", new Object[]{category, action, target, user, details, requestType});
        try {
            AuditLog auditLog = AuditLog.builder().action(action).entityName(category).entityId(target).auditor(user).details(details).requestType(requestType).requestPayload(payload != null ? payload.toString() : null).build();
            this.auditRepository.save((Object)auditLog);
            log.debug("Audit log persisted successfully");
        }
        catch (Exception e) {
            log.error("Failed to persist audit log", (Throwable)e);
        }
    }

    @Generated
    public AuditServiceImpl(AuditRepository auditRepository) {
        this.auditRepository = auditRepository;
    }
}

