/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.method.controller;

import agrota.backagrota.logic.lhia.service.AuthService;
import agrota.backagrota.logic.method.model.KeycloakTokenResponse;
import agrota.backagrota.logic.method.model.LoginRequest;
import agrota.backagrota.logic.method.model.MicrosoftTokenResponse;
import agrota.backagrota.logic.method.service.KeycloakService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    private final AuthService authService;
    private final KeycloakService keycloakService;

    public AuthController(AuthService authService, KeycloakService keycloakService) {
        this.authService = authService;
        this.keycloakService = keycloakService;
    }

    @GetMapping(value={"/microsoft-token"})
    public Mono<ResponseEntity<MicrosoftTokenResponse>> getMicrosoftToken() {
        return this.authService.getToken().map(token -> new MicrosoftTokenResponse(token)).map(ResponseEntity::ok);
    }

    @PostMapping(value={"/login"})
    public Mono<ResponseEntity<KeycloakTokenResponse>> login(@RequestBody LoginRequest request) {
        return this.keycloakService.login(request.getUsername(), request.getPassword()).map(ResponseEntity::ok);
    }
}

