/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.method.config;

import agrota.backagrota.logic.method.config.JwtAuthConverterProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private final JwtAuthConverterProperties properties;

    public JwtAuthConverter(JwtAuthConverterProperties properties) {
        this.properties = properties;
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        Collection authorities = Stream.concat(new JwtGrantedAuthoritiesConverter().convert(jwt).stream(), this.extractResourceRoles(jwt).stream()).collect(Collectors.toSet());
        return new JwtAuthenticationToken(jwt, authorities, this.getPrincipalClaimName(jwt));
    }

    private String getPrincipalClaimName(Jwt jwt) {
        String claimName = "sub";
        if (this.properties.getPrincipalAttribute() != null) {
            claimName = this.properties.getPrincipalAttribute();
        }
        return (String)jwt.getClaim(claimName);
    }

    private Collection<GrantedAuthority> extractResourceRoles(Jwt jwt) {
        Map resource;
        Object object;
        Object object2;
        Map realmAccess = (Map)jwt.getClaim("realm_access");
        Map resourceAccess = (Map)jwt.getClaim("resource_access");
        ArrayList<String> allRoles = new ArrayList<String>();
        if (realmAccess != null && (object2 = realmAccess.get("roles")) instanceof Collection) {
            Collection roles = (Collection)object2;
            object2 = roles.iterator();
            while (object2.hasNext()) {
                Object role2 = object2.next();
                if (!(role2 instanceof String)) continue;
                String s = (String)role2;
                allRoles.add(s);
            }
        }
        if (resourceAccess != null && (object2 = resourceAccess.get(this.properties.getResourceId())) instanceof Map && (object = (resource = (Map)object2).get("roles")) instanceof Collection) {
            Collection roles = (Collection)object;
            for (Object role3 : roles) {
                if (!(role3 instanceof String)) continue;
                String s = (String)role3;
                allRoles.add(s);
            }
        }
        return allRoles.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role)).collect(Collectors.toSet());
    }
}

