/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.method.config;

import agrota.backagrota.logic.method.service.AuditService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuditInterceptor
implements HandlerInterceptor {
    private final AuditService auditService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String action = request.getMethod() + " " + request.getRequestURI();
        String auditor = this.getCurrentUser();
        String requestType = request.getMethod();
        String details = "Remote Addr: " + request.getRemoteAddr();
        this.auditService.log(action, "API_ENDPOINT", request.getRequestURI(), auditor, details, requestType, null);
        return true;
    }

    private String getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return authentication.getName();
        }
        return "anonymousUser";
    }

    @Generated
    public AuditInterceptor(AuditService auditService) {
        this.auditService = auditService;
    }
}

