/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.utils;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ExtractData {
    public String extraerContenido(JsonNode messageNode, String messageType) {
        String extractedContent;
        switch (messageType) {
            case "text": {
                String string = messageNode.path("text").path("body").asText();
                break;
            }
            case "sticker": {
                String string = messageNode.path("sticker").path("id").asText();
                break;
            }
            case "image": 
            case "document": {
                String string;
                String mediaType = messageType.substring(0, 1).toUpperCase() + messageType.substring(1);
                String caption = messageNode.path(messageType).path("caption").asText("");
                String filename = messageNode.path(messageType).path("filename").asText("");
                String id = messageNode.path(messageType).path("id").asText();
                if (id.isEmpty()) {
                    string = "";
                    break;
                }
                if (!caption.isEmpty()) {
                    string = String.format("[%s] ID: %s, Descripci\u00f3n: %s", mediaType, id, caption);
                    break;
                }
                if (!filename.isEmpty()) {
                    string = String.format("[%s] ID: %s, Archivo: %s", mediaType, id, filename);
                    break;
                }
                string = String.format("[%s] ID: %s", mediaType, id);
                break;
            }
            case "interactive": {
                String title;
                String id;
                String string;
                JsonNode listReply = messageNode.path("interactive").path("list_reply");
                JsonNode buttonReply = messageNode.path("interactive").path("button_reply");
                if (!listReply.isMissingNode()) {
                    title = listReply.path("title").asText("");
                    id = listReply.path("id").asText("");
                    if (id.isEmpty()) {
                        string = "";
                        break;
                    }
                    string = String.format("RESPUESTA LISTA: %s (ID: %s)", title, id);
                    break;
                }
                if (!buttonReply.isMissingNode()) {
                    title = buttonReply.path("title").asText("");
                    id = buttonReply.path("id").asText("");
                    if (id.isEmpty()) {
                        string = "";
                        break;
                    }
                    string = String.format("RESPUESTA BOT\u00d3N: %s (ID: %s)", title, id);
                    break;
                }
                string = "";
                break;
            }
            default: {
                String string = extractedContent = "";
            }
        }
        if (extractedContent == null || extractedContent.isBlank()) {
            return "";
        }
        return extractedContent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtractData)) {
            return false;
        }
        ExtractData other = (ExtractData)o;
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExtractData;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "ExtractData()";
    }

    @Generated
    public ExtractData() {
    }
}

