/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.service.whatsapp;

import agrota.backagrota.logic.lhia.dto.ReplyMessageDto;
import agrota.backagrota.logic.lhia.utils.JsonLogger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class WhatsAppMessageSender {
    private final WebClient webClient;
    private final JsonLogger jsonLogger;
    @Value(value="${whatsapp.access-token}")
    private String accessToken;
    @Value(value="${whatsapp.phone-number-id}")
    private String phoneNumberId;
    @Value(value="${whatsapp.api.base-url}")
    private String whatsappApiBaseUrl;
    @Value(value="${whatsapp.api.version}")
    private String whatsappApiVersion;

    public WhatsAppMessageSender(WebClient.Builder webClientBuilder, JsonLogger jsonLogger) {
        this.webClient = webClientBuilder.build();
        this.jsonLogger = jsonLogger;
    }

    public Mono<Void> sendReply(ReplyMessageDto reply) {
        String url = this.whatsappApiBaseUrl + "/" + this.whatsappApiVersion + "/" + this.phoneNumberId + "/messages";
        this.jsonLogger.logJson("\ud83d\udce4 Enviando respuesta a WhatsApp API", (Object)reply);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).header("Authorization", new String[]{"Bearer " + this.accessToken})).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)reply).retrieve().onStatus(status -> !status.is2xxSuccessful(), clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorBody -> {
            System.err.println("\u274c Facebook API Error " + clientResponse.statusCode() + ": " + errorBody);
            this.jsonLogger.logJson("ERROR DETALLADO API FACEBOOK", errorBody);
            return Mono.error((Throwable)new RuntimeException("Facebook API Error: " + errorBody));
        })).bodyToMono(String.class).doOnNext(response -> System.out.println("\u2705 Facebook API Response: " + response)).then();
    }
}

