/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.service.whatsapp;

import io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@Service
public class WhatsAppMediaService {
    private final WebClient webClient;
    private final Map<String, String> mediaIdCache = new ConcurrentHashMap();
    @Value(value="${whatsapp.api.base-url}")
    private String whatsappApiBaseUrl;
    @Value(value="${whatsapp.api.version}")
    private String whatsappApiVersion;
    @Value(value="${whatsapp.access-token}")
    private String accessToken;
    @Value(value="${whatsapp.phone-number-id}")
    private String phoneNumberId;

    public WhatsAppMediaService(WebClient.Builder webClientBuilder) {
        SslContext sslContext;
        try {
            sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creando SSL Context inseguro", e);
        }
        HttpClient httpClient = HttpClient.create().secure(t -> t.sslContext(sslContext));
        this.webClient = webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).build()).build();
    }

    @CircuitBreaker(name="default", fallbackMethod="fallbackGetMediaIdForUrl")
    public Mono<String> getMediaIdForUrl(String imageUrl) {
        if (imageUrl == null || imageUrl.isEmpty()) {
            return Mono.empty();
        }
        if (this.mediaIdCache.containsKey(imageUrl)) {
            return Mono.just((Object)((String)this.mediaIdCache.get(imageUrl)));
        }
        System.out.println("Downloading image from: " + imageUrl);
        return this.webClient.get().uri(imageUrl, new Object[0]).retrieve().bodyToMono(byte[].class).flatMap(imageBytes -> this.uploadToWhatsApp(imageBytes)).doOnNext(mediaId -> {
            if (mediaId != null) {
                this.mediaIdCache.put(imageUrl, mediaId);
            }
        }).onErrorResume(e -> {
            System.err.println("Error processing image URL: " + imageUrl + " - " + e.getMessage());
            return Mono.empty();
        });
    }

    public Mono<String> fallbackGetMediaIdForUrl(String imageUrl, Throwable t) {
        System.err.println("Circuit Breaker fallback for getMediaIdForUrl: " + t.getMessage());
        return Mono.empty();
    }

    @CircuitBreaker(name="default", fallbackMethod="fallbackDownloadMedia")
    public Mono<byte[]> downloadMedia(String mediaId) {
        System.out.println("Attempting to get media URL for ID: " + mediaId);
        return this.webClient.get().uri(this.whatsappApiBaseUrl + "/" + this.whatsappApiVersion + "/" + mediaId, new Object[0]).header("Authorization", new String[]{"Bearer " + this.accessToken}).retrieve().onStatus(status -> status.isError(), response -> response.bodyToMono(String.class).flatMap(errorBody -> {
            System.err.println("Error retrieving media URL from WhatsApp. Status: " + response.statusCode() + ", Body: " + errorBody);
            return Mono.error((Throwable)new RuntimeException("WhatsApp Media API Error: " + response.statusCode()));
        })).bodyToMono(Map.class).flatMap(response -> {
            if (response != null && response.containsKey("url")) {
                String downloadUrl = (String)response.get("url");
                System.out.println("Media URL retrieved: " + downloadUrl);
                return this.webClient.get().uri(downloadUrl, new Object[0]).header("Authorization", new String[]{"Bearer " + this.accessToken}).retrieve().onStatus(status -> status.isError(), downResponse -> downResponse.bodyToMono(String.class).flatMap(errorBody -> {
                    System.err.println("Error downloading media binary from WhatsApp. Status: " + downResponse.statusCode() + ", Body: " + errorBody);
                    return Mono.error((Throwable)new RuntimeException("WhatsApp Download Error: " + downResponse.statusCode()));
                })).bodyToMono(byte[].class).doOnNext(bytes -> System.out.println("Downloaded media size: " + (Serializable)(bytes != null ? Integer.valueOf(((byte[])bytes).length) : "null") + " bytes"));
            }
            System.err.println("Response from WhatsApp Media API lacks 'url' field: " + response);
            return Mono.error((Throwable)new RuntimeException("Could not retrieve media URL for ID: " + mediaId));
        });
    }

    private Mono<String> uploadToWhatsApp(byte[] imageBytes) {
        return Mono.fromCallable(() -> {
            MultipartBodyBuilder builder = new MultipartBodyBuilder();
            builder.part("file", (Object)new /* Unavailable Anonymous Inner Class!! */);
            builder.part("messaging_product", (Object)"whatsapp");
            return builder.build();
        }).flatMap(multipartData -> {
            System.out.println("Uploading image to WhatsApp...");
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.whatsappApiBaseUrl + "/" + this.whatsappApiVersion + "/" + this.phoneNumberId + "/media", new Object[0])).header("Authorization", new String[]{"Bearer " + this.accessToken})).contentType(MediaType.MULTIPART_FORM_DATA).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)multipartData)).retrieve().bodyToMono(Map.class).map(response -> {
                if (response != null && response.containsKey("id")) {
                    String id = (String)response.get("id");
                    System.out.println("Upload successful. Media ID: " + id);
                    return id;
                }
                System.err.println("Upload failed. Response: " + response);
                return null;
            });
        }).onErrorResume(e -> {
            System.err.println("Error uploading to WhatsApp: " + e.getMessage());
            e.printStackTrace();
            return Mono.empty();
        });
    }
}

