/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.service.whatsapp;

import io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TranscriptionService {
    private final WebClient webClient;
    @Value(value="${transcription.api.url}")
    private String transcriptionApiUrl;

    public TranscriptionService(WebClient.Builder webClientBuilder) {
        this.webClient = webClientBuilder.build();
    }

    @CircuitBreaker(name="default", fallbackMethod="fallbackTranscribeAudio")
    public Mono<String> transcribeAudio(byte[] audioData, String filename) {
        return Mono.fromCallable(() -> {
            MultipartBodyBuilder builder = new MultipartBodyBuilder();
            builder.part("file", (Object)new /* Unavailable Anonymous Inner Class!! */);
            return builder.build();
        }).flatMap(multipartData -> ((WebClient.RequestBodySpec)this.webClient.post().uri(this.transcriptionApiUrl, new Object[0])).contentType(MediaType.MULTIPART_FORM_DATA).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)multipartData)).retrieve().bodyToMono(Map.class).map(response -> {
            System.out.println("Transcription API Response: " + response);
            if (response != null && response.containsKey("transcripcion")) {
                return (String)response.get("transcripcion");
            }
            return "";
        }));
    }

    public Mono<String> fallbackTranscribeAudio(byte[] audioData, String filename, Throwable t) {
        System.err.println("Circuit Breaker fallback for transcribeAudio: " + t.getMessage());
        return Mono.just((Object)"");
    }
}

