/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.service.whatsapp;

import agrota.backagrota.logic.lhia.dto.MessageResponseDto;
import agrota.backagrota.logic.lhia.dto.ReplyMessageDto;
import agrota.backagrota.logic.lhia.dto.whatsapp.MessageTextRequestDto;
import agrota.backagrota.logic.lhia.model.BotUser;
import agrota.backagrota.logic.lhia.model.Conversation;
import agrota.backagrota.logic.lhia.model.Message;
import agrota.backagrota.logic.lhia.repository.BotUserRepository;
import agrota.backagrota.logic.lhia.service.ConversationService;
import agrota.backagrota.logic.lhia.service.FileStorageService;
import agrota.backagrota.logic.lhia.service.LhiaService;
import agrota.backagrota.logic.lhia.service.MessageService;
import agrota.backagrota.logic.lhia.service.RedisService;
import agrota.backagrota.logic.lhia.service.whatsapp.MessageProcessService;
import agrota.backagrota.logic.lhia.service.whatsapp.TranscriptionService;
import agrota.backagrota.logic.lhia.service.whatsapp.WhatsAppMediaService;
import agrota.backagrota.logic.lhia.service.whatsapp.WhatsAppMessageSender;
import agrota.backagrota.logic.lhia.utils.ExtractData;
import agrota.backagrota.logic.lhia.utils.JsonLogger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class MessageProcessService {
    private final ConversationService conversationService;
    private final MessageService messageService;
    private final JsonLogger jsonLogger;
    private final LhiaService lhiaService;
    private final ExtractData extractData;
    private final ObjectMapper objectMapper;
    private final RedisService redisService;
    private final WhatsAppMediaService whatsAppMediaService;
    private final TranscriptionService transcriptionService;
    private final FileStorageService fileStorageService;
    private final WhatsAppMessageSender whatsAppMessageSender;
    private final BotUserRepository botUserRepository;
    @Value(value="${whatsapp.whitelist.numbers}")
    private List<String> whitelist;
    @Value(value="${whatsapp.auth.username}")
    private String authUsername;
    @Value(value="${whatsapp.auth.password}")
    private String authPassword;
    private static final List<String> TiposPermitidos = List.of("text", "image", "audio", "interactive");

    public Mono<MessageResponseDto> procesarMensaje(JsonNode body) {
        try {
            this.jsonLogger.logJson("EVENTO ENTRANTE JSON", (Object)body);
            JsonNode messagesNode = this.getMessagesNode(body);
            if (messagesNode == null || !messagesNode.isArray() || messagesNode.isEmpty()) {
                System.out.println("No valid 'messages' array found in payload.");
                return Mono.empty();
            }
            JsonNode messageNode = messagesNode.get(0);
            String whatsapp = messageNode.path("from").asText();
            try {
                this.redisService.saveSessionHistory(whatsapp, (Object)body).subscribe();
            }
            catch (Exception e) {
                System.err.println("Error saving Redis history: " + e.getMessage());
            }
            JsonNode contactsNode = this.getContactsNode(body);
            String username = contactsNode != null && !contactsNode.isEmpty() ? contactsNode.path(0).path("profile").path("name").asText(whatsapp) : whatsapp;
            String wamid = messageNode.path("id").asText();
            String messageType = messageNode.path("type").asText();
            if (!TiposPermitidos.contains(messageType)) {
                this.jsonLogger.logJson("MENSAJE IGNORADO", (Object)("Tipo de mensaje no permitido: " + messageType));
                return Mono.empty();
            }
            return Mono.fromCallable(() -> this.botUserRepository.findByWhatsapp(whatsapp)).subscribeOn(Schedulers.boundedElastic()).flatMap(optionalRegisteredUser -> {
                if (optionalRegisteredUser.isPresent()) {
                    BotUser user = (BotUser)optionalRegisteredUser.get();
                    return this.redisService.isUserAuthenticated(whatsapp).flatMap(isAuthenticated -> {
                        if (Boolean.TRUE.equals(isAuthenticated)) {
                            return this.processMessageContent(messageNode, messageType, whatsapp, username, wamid, body);
                        }
                        String content = this.extractData.extraerContenido(messageNode, messageType).trim();
                        if (content.equals(user.getCedula())) {
                            return this.redisService.saveAuthToken(whatsapp).then(this.sendSimpleReply(whatsapp, "\u2705 \u00a1Identidad confirmada! \u00a1Bienvenido " + user.getName() + "! \ud83c\udf89\n\n\u00bfEn qu\u00e9 puedo apoyarte hoy con los datos de Agrota?")).thenReturn((Object)MessageResponseDto.builder().status("ok").build());
                        }
                        return this.sendSimpleReply(whatsapp, "\u00a1Hola! \ud83d\udc4b Para acceder a tus consultas de Agrota, por favor ingresa tu **ID (C\u00e9dula)** de verificaci\u00f3n:").thenReturn((Object)MessageResponseDto.builder().status("awaiting_id").build());
                    });
                }
                this.jsonLogger.logJson("ACCESO DENEGADO (SILENCIO)", (Object)("N\u00famero no registrado: " + whatsapp));
                return Mono.empty();
            });
        }
        catch (Exception e) {
            System.err.println("Critical Error in procesarMensaje (Sync): " + e.getMessage());
            e.printStackTrace();
            return Mono.error((Throwable)e);
        }
    }

    private Mono<Void> sendSimpleReply(String to, String body) {
        ReplyMessageDto.TextContent textContent = new ReplyMessageDto.TextContent();
        textContent.setBody(body);
        ReplyMessageDto reply = ReplyMessageDto.builder().messagingProduct("whatsapp").recipientType("individual").to(to).type("text").text(textContent).build();
        return this.whatsAppMessageSender.sendReply(reply);
    }

    private JsonNode getMessagesNode(JsonNode body) {
        if (body.has("messages")) {
            return body.path("messages");
        }
        return body.path("entry").path(0).path("changes").path(0).path("value").path("messages");
    }

    private JsonNode getContactsNode(JsonNode body) {
        if (body.has("contacts")) {
            return body.path("contacts");
        }
        return body.path("entry").path(0).path("changes").path(0).path("value").path("contacts");
    }

    private Mono<MessageResponseDto> processMessageContent(JsonNode messageNode, String messageType, String whatsapp, String username, String wamid, JsonNode body) {
        Mono finalMessageTypeMono;
        Mono contentMono;
        if ("audio".equals(messageType)) {
            String audioId = messageNode.path("audio").path("id").asText();
            Mono mediaMono = this.whatsAppMediaService.downloadMedia(audioId).cache();
            Mono transcriptionMono = mediaMono.flatMap(bytes -> {
                if (bytes == null || ((byte[])bytes).length == 0) {
                    this.jsonLogger.logJson("ERROR AUDIO", (Object)"Audio bytes are null or empty");
                    return Mono.just((Object)"[Error: Audio vac\u00edo]");
                }
                this.jsonLogger.logJson("PROCESANDO AUDIO", (Object)("Tama\u00f1o: " + ((byte[])bytes).length + " bytes"));
                return this.transcriptionService.transcribeAudio(bytes, "audio.ogg").doOnNext(text -> {
                    this.jsonLogger.logJson("AUDIO TRANSCRITO LOG", (Object)("Texto: " + text));
                    System.out.println(">>> AUDIO TRANSCRITO EXITOSAMENTE: " + text);
                });
            }).onErrorResume(e -> {
                this.jsonLogger.logJson("ERROR TRANSCRIPCION", (Object)e.getMessage());
                return Mono.just((Object)"[Error transcribiendo audio]");
            });
            Mono uploadMono = mediaMono.flatMap(bytes -> this.fileStorageService.uploadFile(bytes, audioId, "audio/ogg", "odoo")).onErrorResume(e -> {
                this.jsonLogger.logJson("ERROR SUBIDA", (Object)e.getMessage());
                return Mono.just((Object)"UPLOAD_FAILED");
            });
            contentMono = Mono.zip((Mono)transcriptionMono, (Mono)uploadMono).map(tuple -> {
                String transcription = (String)tuple.getT1();
                String url = (String)tuple.getT2();
                return url + "|||" + transcription;
            }).switchIfEmpty(transcriptionMono);
            finalMessageTypeMono = Mono.just((Object)"audio");
        } else {
            contentMono = Mono.just((Object)this.extractData.extraerContenido(messageNode, messageType));
            finalMessageTypeMono = Mono.just((Object)messageType);
        }
        return Mono.zip((Mono)contentMono, (Mono)finalMessageTypeMono).flatMap(tuple -> {
            String rawContent = (String)tuple.getT1();
            String finalType = (String)tuple.getT2();
            String tempDbContent = rawContent;
            String tempBotContent = rawContent;
            if ("audio".equals(finalType) && rawContent.contains("|||")) {
                String[] parts = rawContent.split("\\|\\|\\|", 2);
                tempDbContent = parts[0];
                tempBotContent = parts[1];
            }
            String dbContent = tempDbContent;
            String botContent = tempBotContent;
            return this.guardarConversacion(whatsapp, username).flatMap(conversation -> this.guardarMensaje(conversation.getId(), wamid, "user", finalType, dbContent, body.toString()).flatMap(userMessage -> {
                if (botContent != null && botContent.startsWith("[Error")) {
                    this.jsonLogger.logJson("AUDIO ERROR - NO ENVIANDO A MCP", (Object)botContent);
                    ReplyMessageDto.TextContent textContent = new ReplyMessageDto.TextContent();
                    textContent.setBody("Lo siento, no pude entender el audio. \u00bfPodr\u00edas intentar enviarlo de nuevo o escribir tu consulta? \ud83c\udfa4");
                    ReplyMessageDto errorReply = ReplyMessageDto.builder().messagingProduct("whatsapp").recipientType("individual").to(whatsapp).type("text").text(textContent).build();
                    MessageResponseDto errorResponseObj = MessageResponseDto.builder().status("error_transcription").messagesReceived(1).repliesCount(1).timestamp(System.currentTimeMillis()).replies(List.of(errorReply)).build();
                    return Mono.just((Object)errorResponseObj);
                }
                return Mono.fromCallable(() -> this.botUserRepository.findByWhatsapp(whatsapp)).subscribeOn(Schedulers.boundedElastic()).flatMap(optionalUser -> {
                    String userName = optionalUser.map(BotUser::getName).orElse(username);
                    String userPosition = optionalUser.map(BotUser::getPosition).orElse("");
                    this.jsonLogger.logJson("ENVIANDO A MCP", (Object)("Contenido: " + botContent + " | Usuario: " + userName));
                    return this.preguntarLhia(body, botContent, finalType, userName, userPosition).flatMap(responseDto -> {
                        if (responseDto.getReplies() == null || responseDto.getReplies().isEmpty()) {
                            return Mono.just((Object)responseDto);
                        }
                        return Flux.fromIterable((Iterable)responseDto.getReplies()).index().flatMap(replyTuple -> Mono.just((Object)responseDto)).then(Mono.just((Object)responseDto));
                    });
                });
            }));
        }).onErrorResume(e -> {
            this.jsonLogger.logJson("ERROR EN PROCESAMIENTO", (Object)e.getMessage());
            ReplyMessageDto.TextContent textContent = new ReplyMessageDto.TextContent();
            textContent.setBody("Error en procesamiento: " + e.getMessage());
            ReplyMessageDto errorReply = ReplyMessageDto.builder().messagingProduct("whatsapp").recipientType("individual").to(whatsapp).type("text").text(textContent).build();
            MessageResponseDto errorResponseObj = MessageResponseDto.builder().status("error").messagesReceived(0).repliesCount(1).timestamp(System.currentTimeMillis()).replies(List.of(errorReply)).build();
            return Mono.just((Object)errorResponseObj);
        });
    }

    public Mono<Conversation> guardarConversacion(String whatsapp, String username) {
        return this.conversationService.findByWhatsapp(whatsapp).flatMap(existingConversation -> {
            existingConversation.setUsername(username);
            existingConversation.setLastInteraction(LocalDateTime.now());
            this.redisService.saveUserSession(whatsapp, username).subscribe();
            return this.conversationService.save(existingConversation);
        }).switchIfEmpty(Mono.defer(() -> {
            Conversation newConversation = new Conversation(null, whatsapp, username, LocalDateTime.now(), LocalDateTime.now());
            this.redisService.saveUserSession(whatsapp, username).subscribe();
            return this.conversationService.save(newConversation);
        }));
    }

    public Mono<Message> guardarMensaje(Long conversation_id, String whamid, String sender, String type, String content, String rawBody) {
        return this.messageService.save(new Message(null, conversation_id, whamid, sender, type, content, rawBody, LocalDateTime.now()));
    }

    public Mono<MessageResponseDto> preguntarLhia(JsonNode jsonNode, String textOverride, String typeOverride, String userName, String userPosition) {
        JsonNode messageNode = jsonNode.path("messages").get(0);
        String text = textOverride != null ? textOverride : messageNode.path("text").path("body").asText();
        String type = typeOverride != null ? typeOverride : messageNode.path("type").asText();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode contextNode = mapper.createObjectNode();
        contextNode.put("userName", userName);
        contextNode.put("userPosition", userPosition);
        if ("audio".equals(type) && textOverride != null) {
            MessageTextRequestDto textRequest = new MessageTextRequestDto();
            textRequest.setMessagingProduct("whatsapp");
            textRequest.setRecipientType("individual");
            textRequest.setTo(messageNode.path("from").asText());
            textRequest.setType("text");
            textRequest.setText(new MessageTextRequestDto.TextBodyDto(textOverride, false));
            JsonNode payload = this.objectMapper.valueToTree((Object)textRequest);
            ((ObjectNode)payload).set("context", (JsonNode)contextNode);
            this.jsonLogger.logJson("PAYLOAD FINAL A MCP (AUDIO -> TEXT)", (Object)payload);
            return this.lhiaService.sendMessageToClient(payload);
        }
        MessageTextRequestDto textRequest = new MessageTextRequestDto();
        textRequest.setMessagingProduct("whatsapp");
        textRequest.setRecipientType("individual");
        textRequest.setTo(messageNode.path("from").asText());
        textRequest.setType("text");
        textRequest.setText(new MessageTextRequestDto.TextBodyDto(text, false));
        JsonNode payload = this.objectMapper.valueToTree((Object)textRequest);
        ((ObjectNode)payload).set("context", (JsonNode)contextNode);
        this.jsonLogger.logJson("PAYLOAD FINAL A MCP (TEXT)", (Object)payload);
        return this.lhiaService.sendMessageToClient(payload);
    }

    private Credentials extractCredentials(String content) {
        String[] parts;
        if (content == null) {
            return null;
        }
        String cleanContent = content.trim();
        if (cleanContent.toLowerCase().startsWith("login ") && (parts = cleanContent.split("\\s+")).length == 3) {
            String user = parts[1].replace("<", "").replace(">", "");
            String pass = parts[2].replace("<", "").replace(">", "");
            return new Credentials(user, pass);
        }
        Pattern userPattern = Pattern.compile("(?i)(?:usuario|user)(?:\\s+(?:es|is))?[:\\s=]+([^\\s,;]+)");
        Pattern passPattern = Pattern.compile("(?i)(?:clave|password|contrase\u00f1a)(?:\\s+(?:es|is))?[:\\s=]+([^\\s,;]+)");
        Matcher userMatcher = userPattern.matcher(cleanContent);
        Matcher passMatcher = passPattern.matcher(cleanContent);
        if (userMatcher.find() && passMatcher.find()) {
            String user = userMatcher.group(1).replace("<", "").replace(">", "").replace("\"", "").replace("'", "");
            String pass = passMatcher.group(1).replace("<", "").replace(">", "").replace("\"", "").replace("'", "");
            return new Credentials(user, pass);
        }
        return null;
    }

    private String extractReplyContent(ReplyMessageDto reply) {
        if (reply == null || reply.getType() == null) {
            return "";
        }
        String type = reply.getType();
        if ("text".equals(type)) {
            return reply.getText() != null ? reply.getText().getBody() : "";
        }
        if ("interactive".equals(type)) {
            if (reply.getInteractive() != null && reply.getInteractive().getBody() != null) {
                return reply.getInteractive().getBody().getText();
            }
            return "[Interactive Message]";
        }
        if ("image".equals(type)) {
            String caption = reply.getImage() != null && reply.getImage().getCaption() != null ? reply.getImage().getCaption() : "";
            return "[Image] " + caption;
        }
        return "[" + type + "]";
    }

    @Generated
    public MessageProcessService(ConversationService conversationService, MessageService messageService, JsonLogger jsonLogger, LhiaService lhiaService, ExtractData extractData, ObjectMapper objectMapper, RedisService redisService, WhatsAppMediaService whatsAppMediaService, TranscriptionService transcriptionService, FileStorageService fileStorageService, WhatsAppMessageSender whatsAppMessageSender, BotUserRepository botUserRepository) {
        this.conversationService = conversationService;
        this.messageService = messageService;
        this.jsonLogger = jsonLogger;
        this.lhiaService = lhiaService;
        this.extractData = extractData;
        this.objectMapper = objectMapper;
        this.redisService = redisService;
        this.whatsAppMediaService = whatsAppMediaService;
        this.transcriptionService = transcriptionService;
        this.fileStorageService = fileStorageService;
        this.whatsAppMessageSender = whatsAppMessageSender;
        this.botUserRepository = botUserRepository;
    }
}

