/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.service.impl;

import agrota.backagrota.logic.lhia.service.RedisService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    private final ReactiveStringRedisTemplate redisTemplate;
    private final ObjectMapper objectMapper;
    public static final String PROD_PREFIX = "card_cache_prod:";
    public static final String MSG_PREFIX = "card_cache_msg:";
    private static final Duration CACHE_EXPIRATION = Duration.ofDays(1L);

    public Mono<Void> saveCard(String id, String prefix, String to, Object cardData) {
        if (id == null || id.isEmpty() || "ID_DEFAULT".equals(id)) {
            return Mono.empty();
        }
        return Mono.fromCallable(() -> this.objectMapper.writeValueAsString(Map.of("to", to, "interactive", cardData))).flatMap(json -> {
            String key = prefix + id;
            log.info("\ud83d\uddc4\ufe0f Persistiendo card en Redis: {}", (Object)key);
            return this.redisTemplate.opsForValue().set((Object)key, json, CACHE_EXPIRATION);
        }).doOnError(e -> log.error("\u274c Error guardando card en Redis para ID {}: {}", (Object)id, (Object)e.getMessage())).then();
    }

    public Mono<Void> saveSessionHistory(String whatsapp, Object messageData) {
        String key = "session_history:" + whatsapp;
        return Mono.fromCallable(() -> this.objectMapper.writeValueAsString(messageData)).flatMap(json -> this.redisTemplate.opsForList().rightPush((Object)key, json)).flatMap(index -> this.redisTemplate.expire((Object)key, Duration.ofDays(1L))).then().doOnError(e -> log.error("\u274c Error guardando historial de sesi\u00f3n para {}: {}", (Object)whatsapp, (Object)e.getMessage()));
    }

    public Mono<Void> saveUserSession(String whatsapp, String username) {
        String key = "user_session:" + whatsapp;
        return Mono.fromCallable(() -> this.objectMapper.writeValueAsString(Map.of("username", username, "whatsapp", whatsapp))).flatMap(json -> this.redisTemplate.opsForValue().set((Object)key, json, Duration.ofDays(1L))).then().doOnError(e -> log.error("\u274c Error guardando sesi\u00f3n de usuario para {}: {}", (Object)whatsapp, (Object)e.getMessage()));
    }

    public Mono<Void> saveAdminToken(String token) {
        String key = "admin_token";
        return this.redisTemplate.opsForValue().set((Object)key, (Object)token).then().doOnError(e -> log.error("\u274c Error guardando token de admin: {}", (Object)e.getMessage()));
    }

    public Mono<String> getAdminToken() {
        return this.redisTemplate.opsForValue().get((Object)"admin_token");
    }

    public Mono<Void> saveAuthToken(String whatsapp) {
        String key = "auth:whatsapp:" + whatsapp;
        return this.redisTemplate.opsForValue().set((Object)key, (Object)"authenticated", Duration.ofDays(1L)).then().doOnError(e -> log.error("\u274c Error guardando token de autenticaci\u00f3n para {}: {}", (Object)whatsapp, (Object)e.getMessage()));
    }

    public Mono<Boolean> isUserAuthenticated(String whatsapp) {
        String key = "auth:whatsapp:" + whatsapp;
        return this.redisTemplate.hasKey((Object)key);
    }

    public Mono<Void> saveLoginFlowData(String whatsapp, Map<String, String> data) {
        String key = "login_flow:" + whatsapp;
        return Mono.fromCallable(() -> this.objectMapper.writeValueAsString((Object)data)).flatMap(json -> this.redisTemplate.opsForValue().set((Object)key, json, Duration.ofMinutes(15L))).then().doOnError(e -> log.error("\u274c Error guardando datos de flujo de login para {}: {}", (Object)whatsapp, (Object)e.getMessage()));
    }

    public Mono<Map<String, String>> getLoginFlowData(String whatsapp) {
        String key = "login_flow:" + whatsapp;
        return this.redisTemplate.opsForValue().get((Object)key).flatMap(json -> {
            try {
                Map map = (Map)this.objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                return Mono.just((Object)map);
            }
            catch (Exception e) {
                return Mono.empty();
            }
        });
    }

    public Mono<Void> clearLoginFlowData(String whatsapp) {
        String key = "login_flow:" + whatsapp;
        return this.redisTemplate.delete((Object[])new String[]{key}).then();
    }

    @Generated
    public RedisServiceImpl(ReactiveStringRedisTemplate redisTemplate, ObjectMapper objectMapper) {
        this.redisTemplate = redisTemplate;
        this.objectMapper = objectMapper;
    }
}

