/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.service.impl;

import agrota.backagrota.logic.lhia.service.AuthService;
import agrota.backagrota.logic.lhia.service.FileStorageService;
import agrota.backagrota.logic.lhia.utils.JsonLogger;
import com.fasterxml.jackson.databind.JsonNode;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.Base64;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@Service
public class FileStorageServiceImpl
implements FileStorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileStorageServiceImpl.class);
    private final WebClient webClient;
    private final JsonLogger jsonLogger;
    private final AuthService authService;
    @Value(value="${server.upload.file.url:https://agrota.lhia.ai/api-files-bot/v1/stored-file/save}")
    private String uploadUrl;

    public FileStorageServiceImpl(WebClient.Builder webClientBuilder, JsonLogger jsonLogger, AuthService authService) {
        SslContext sslContext;
        this.jsonLogger = jsonLogger;
        this.authService = authService;
        try {
            sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creando SSL Context inseguro", e);
        }
        HttpClient httpClient = HttpClient.create().secure(t -> t.sslContext(sslContext));
        this.webClient = webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).build()).build();
    }

    public Mono<String> uploadFile(byte[] fileBytes, String id, String contentType, String folder) {
        return Mono.fromCallable(() -> {
            String base64 = Base64.getEncoder().encodeToString(fileBytes);
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("base64", base64);
            payload.put("contentType", contentType);
            payload.put("folder", folder);
            payload.put("id", id);
            return payload;
        }).flatMap(payload -> {
            this.jsonLogger.logJson("SUBIENDO ARCHIVO", payload);
            return this.authService.getToken().flatMap(token -> ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.uploadUrl, new Object[0])).header("Authorization", new String[]{"Bearer " + token})).contentType(MediaType.APPLICATION_JSON).bodyValue(payload).retrieve().bodyToMono(JsonNode.class)).map(response -> {
                this.jsonLogger.logJson("RESPUESTA UPLOAD", response);
                if (response.path("success").asBoolean()) {
                    return response.path("payload").path("path").asText();
                }
                throw new RuntimeException("Upload failed: " + response.path("message").asText());
            });
        }).onErrorResume(e -> {
            this.jsonLogger.logJson("ERROR UPLOAD FILE", (Object)e.getMessage());
            return Mono.empty();
        });
    }
}

