/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.service.impl;

import agrota.backagrota.logic.lhia.service.AuthService;
import agrota.backagrota.logic.method.model.KeycloakTokenResponse;
import agrota.backagrota.logic.method.service.KeycloakService;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private final KeycloakService keycloakService;
    private final AtomicReference<Mono<String>> tokenCache = new AtomicReference();

    public Mono<String> getToken() {
        return Mono.defer(() -> {
            Mono tokenMono = (Mono)this.tokenCache.get();
            if (tokenMono == null) {
                tokenMono = this.login().cache().doOnError(e -> {
                    log.error("Failed to obtain initial token", e);
                    this.tokenCache.set(null);
                });
                if (this.tokenCache.compareAndSet(null, tokenMono)) {
                    return tokenMono;
                }
                return (Mono)this.tokenCache.get();
            }
            return tokenMono;
        });
    }

    public void invalidateToken() {
        log.info("Invalidating expired or invalid JWT token");
        this.tokenCache.set(null);
    }

    private Mono<String> login() {
        return this.keycloakService.getToken().map(KeycloakTokenResponse::getAccessToken).doOnNext(t -> log.info("New JWT Token obtained successfully"));
    }

    @Generated
    public AuthServiceImpl(KeycloakService keycloakService) {
        this.keycloakService = keycloakService;
    }
}

