/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.service;

import agrota.backagrota.logic.lhia.dto.MessageResponseDto;
import agrota.backagrota.logic.lhia.utils.JsonLogger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class LhiaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LhiaService.class);
    private final WebClient.Builder webClient;
    private final Environment env;
    private final ObjectMapper objectMapper;
    private final JsonLogger jsonLogger;

    public Mono<MessageResponseDto> sendMessageToClient(JsonNode jsonNode) {
        String URL2 = this.env.getProperty("api.client.mcp");
        this.jsonLogger.logJson("\ud83d\udce4 Enviando payload a MCP", (Object)jsonNode);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(URL2, new Object[0])).contentType(MediaType.APPLICATION_JSON).acceptCharset(new Charset[]{StandardCharsets.UTF_8})).bodyValue((Object)jsonNode).retrieve().bodyToMono(MessageResponseDto.class).doOnNext(response -> {
            log.info("\u2705 Conexi\u00f3n exitosa con Cliente MCP en: {}", (Object)URL2);
            this.jsonLogger.logJson("\ud83d\udce5 Respuesta recibida desde Cliente MCP", response);
        }).doOnError(error -> log.error("\u274c Error conectando con Cliente MCP en {}: {}", (Object)URL2, (Object)error.getMessage()));
    }

    @Generated
    public WebClient.Builder getWebClient() {
        return this.webClient;
    }

    @Generated
    public Environment getEnv() {
        return this.env;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public JsonLogger getJsonLogger() {
        return this.jsonLogger;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LhiaService)) {
            return false;
        }
        LhiaService other = (LhiaService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebClient.Builder this$webClient = this.getWebClient();
        WebClient.Builder other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        JsonLogger this$jsonLogger = this.getJsonLogger();
        JsonLogger other$jsonLogger = other.getJsonLogger();
        return !(this$jsonLogger == null ? other$jsonLogger != null : !this$jsonLogger.equals(other$jsonLogger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LhiaService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebClient.Builder $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        JsonLogger $jsonLogger = this.getJsonLogger();
        result = result * 59 + ($jsonLogger == null ? 43 : $jsonLogger.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LhiaService(webClient=" + this.getWebClient() + ", env=" + this.getEnv() + ", objectMapper=" + this.getObjectMapper() + ", jsonLogger=" + this.getJsonLogger() + ")";
    }

    @Generated
    public LhiaService(WebClient.Builder webClient, Environment env, ObjectMapper objectMapper, JsonLogger jsonLogger) {
        this.webClient = webClient;
        this.env = env;
        this.objectMapper = objectMapper;
        this.jsonLogger = jsonLogger;
    }
}

