/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.logic.lhia.controller;

import agrota.backagrota.logic.lhia.dto.MessageResponseDto;
import agrota.backagrota.logic.lhia.service.whatsapp.MessageProcessService;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"webhook"})
public class WhatsAppEventController {
    private final MessageProcessService messageProcessService;
    private final Environment env;

    @PostMapping
    public Mono<ResponseEntity<MessageResponseDto>> receiveWebhook(@RequestHeader(value="LHIA-AGROTA", required=true) String apiKey, @RequestBody JsonNode body) {
        String CLIENT_API_KEY = this.env.getProperty("client.api.key");
        if (!apiKey.equals(CLIENT_API_KEY)) {
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build());
        }
        return this.messageProcessService.procesarMensaje(body).map(ResponseEntity::ok);
    }

    @Generated
    public WhatsAppEventController(MessageProcessService messageProcessService, Environment env) {
        this.messageProcessService = messageProcessService;
        this.env = env;
    }
}

