/*
 * Decompiled with CFR 0.152.
 */
package agrota.backagrota.exception;

import agrota.backagrota.exception.PowerBIException;
import java.time.LocalDateTime;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={PowerBIException.class})
    public ResponseEntity<Object> handlePowerBIException(PowerBIException ex, WebRequest request) {
        log.error("PowerBI Exception: {}", (Object)ex.getMessage());
        return this.buildErrorResponse(ex.getMessage(), ex.getStatus(), request);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleGeneralException(Exception ex, WebRequest request) {
        log.error("Unexpected error occurred: ", (Throwable)ex);
        return this.buildErrorResponse("An unexpected error occurred", HttpStatus.INTERNAL_SERVER_ERROR, request);
    }

    private ResponseEntity<Object> buildErrorResponse(String message, HttpStatus status, WebRequest request) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("timestamp", LocalDateTime.now());
        body.put("status", status.value());
        body.put("error", status.getReasonPhrase());
        body.put("message", message);
        body.put("path", request.getDescription(false).replace("uri=", ""));
        return new ResponseEntity(body, (HttpStatusCode)status);
    }
}

