/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.service.integration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.sample.server.tools.service.integration.FlightIntegrationService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class FlightIntegrationServiceImpl
implements FlightIntegrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlightIntegrationServiceImpl.class);
    private final WebClient webClient;
    private final ObjectMapper objectMapper;

    public FlightIntegrationServiceImpl(WebClient.Builder webClientBuilder, @Value(value="${app.api.flight-url}") String apiUrl, ObjectMapper objectMapper) {
        this.webClient = webClientBuilder.baseUrl(apiUrl).build();
        this.objectMapper = objectMapper;
        log.info("FlightIntegrationService initialized with URL: {}", (Object)apiUrl);
    }

    public String getArribos() {
        log.debug("Fetching all flights to extract arribos...");
        try {
            String jsonResponse = (String)this.webClient.get().uri("/api/cuenca-vuelos", new Object[0]).retrieve().bodyToMono(String.class).block();
            log.info("API RESPONSE [/api/cuenca-vuelos]: {}", (Object)jsonResponse);
            JsonNode root = this.objectMapper.readTree(jsonResponse);
            if (root.has("arribos")) {
                String result = root.get("arribos").toString();
                log.info("Extracted Arribos: {}", (Object)(result.substring(0, Math.min(result.length(), 100)) + "..."));
                return result;
            }
            log.warn("Node 'arribos' not found in API response");
            return "[]";
        }
        catch (Exception e) {
            log.error("CRITICAL ERROR fetching arribos: {}", (Object)e.getMessage(), (Object)e);
            return "Error retrieving arrivals: " + e.getMessage();
        }
    }

    public String getSalidas() {
        log.debug("Fetching all flights to extract salidas...");
        try {
            String jsonResponse = (String)this.webClient.get().uri("/api/cuenca-vuelos", new Object[0]).retrieve().bodyToMono(String.class).block();
            log.info("API RESPONSE [/api/cuenca-vuelos]: {}", (Object)jsonResponse);
            JsonNode root = this.objectMapper.readTree(jsonResponse);
            if (root.has("salidas")) {
                String result = root.get("salidas").toString();
                log.info("Extracted Salidas: {}", (Object)(result.substring(0, Math.min(result.length(), 100)) + "..."));
                return result;
            }
            log.warn("Node 'salidas' not found in API response");
            return "[]";
        }
        catch (Exception e) {
            log.error("CRITICAL ERROR fetching salidas: {}", (Object)e.getMessage(), (Object)e);
            return "Error retrieving departures: " + e.getMessage();
        }
    }
}

