/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.service.integration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.sample.server.tools.service.integration.EmailIntegrationService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class EmailIntegrationServiceImpl
implements EmailIntegrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailIntegrationServiceImpl.class);
    private final WebClient webClient;
    private final ObjectMapper objectMapper;
    @Value(value="${app.api.email.token-url:https://login.tws2.io/auth/realms/administracion/protocol/openid-connect/token}")
    private String tokenUrl;
    @Value(value="${app.api.email.send-url:https://back.correos.tws2.io/correo-service/correo/send}")
    private String emailSendUrl;

    public EmailIntegrationServiceImpl(WebClient.Builder webClientBuilder, ObjectMapper objectMapper) {
        this.webClient = webClientBuilder.build();
        this.objectMapper = objectMapper;
    }

    public String sendTicketEmail(String name, String email, String subject, String htmlContent, List<Map<String, Object>> files) {
        log.info("EmailIntegration: Iniciando env\u00edo de boleto para {} <{}> Con archivos: {}", new Object[]{name, email, files != null ? files.size() : 0});
        try {
            String token = this.getAccessToken();
            if (token == null || token.isBlank()) {
                log.error("EmailIntegration: Token de autenticaci\u00f3n es NULL o vac\u00edo.");
                return "Error: No se pudo obtener el token de autenticaci\u00f3n para el servicio de correos.";
            }
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("destinatarios", List.of(email));
            payload.put("contentisHtml", true);
            payload.put("asunto", subject);
            payload.put("contenido", htmlContent);
            payload.put("codigoEmail", "KRLlILAqJsigWtQrAc1UiwtMA0sMnueD");
            payload.put("archivos", files != null ? files : List.of());
            if (files != null) {
                log.info("Archivos adjuntos: {}", (Object)files.size());
            }
            log.debug("EmailIntegration: Enviando payload a {}", (Object)this.emailSendUrl);
            String response = (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.emailSendUrl, new Object[0])).header("Authorization", new String[]{"Bearer " + token})).contentType(MediaType.APPLICATION_JSON).bodyValue(payload).retrieve().bodyToMono(String.class).block();
            log.info("EmailIntegration: Respuesta del servicio de email: {}", (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("EmailIntegration: Error enviando email: {}", (Object)e.getMessage(), (Object)e);
            return "Error al remitir la factura: " + e.getMessage();
        }
    }

    private String getAccessToken() {
        log.debug("EmailIntegration: Solicitando token a Keycloak...");
        try {
            LinkedMultiValueMap formData = new LinkedMultiValueMap();
            formData.add((Object)"username", (Object)"emailservice");
            formData.add((Object)"password", (Object)"X}5E&fY\\ca#Y)u*Q");
            formData.add((Object)"client_id", (Object)"logueoBack");
            formData.add((Object)"grant_type", (Object)"password");
            String response = (String)((WebClient.RequestBodySpec)this.webClient.post().uri(this.tokenUrl, new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)formData)).retrieve().bodyToMono(String.class).block();
            JsonNode root = this.objectMapper.readTree(response);
            return root.path("access_token").asText();
        }
        catch (Exception e) {
            log.error("EmailIntegration: Error obteniendo token: {}", (Object)e.getMessage());
            return null;
        }
    }
}

