/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.service;

import java.util.List;
import org.springframework.ai.mcp.sample.server.tools.service.Vuelo;

record ItinerarioResponse(String fuente, List<Vuelo> salidas, List<Vuelo> arribos, int total_salidas, int total_arribos, boolean success, String error) {
    private final String fuente;
    private final List<Vuelo> salidas;
    private final List<Vuelo> arribos;
    private final int total_salidas;
    private final int total_arribos;
    private final boolean success;
    private final String error;

    ItinerarioResponse(String fuente, List<Vuelo> salidas, List<Vuelo> arribos, int total_salidas, int total_arribos, boolean success, String error) {
        this.fuente = fuente;
        this.salidas = salidas;
        this.arribos = arribos;
        this.total_salidas = total_salidas;
        this.total_arribos = total_arribos;
        this.success = success;
        this.error = error;
    }

    public static ItinerarioResponse success(String fuente, List<Vuelo> salidas, List<Vuelo> arribos, int total_salidas, int total_arribos) {
        return new ItinerarioResponse(fuente, salidas, arribos, total_salidas, total_arribos, true, null);
    }

    public static ItinerarioResponse error(String errorMessage) {
        return new ItinerarioResponse(null, List.of(), List.of(), 0, 0, false, errorMessage);
    }

    public String fuente() {
        return this.fuente;
    }

    public List<Vuelo> salidas() {
        return this.salidas;
    }

    public List<Vuelo> arribos() {
        return this.arribos;
    }

    public int total_salidas() {
        return this.total_salidas;
    }

    public int total_arribos() {
        return this.total_arribos;
    }

    public boolean success() {
        return this.success;
    }

    public String error() {
        return this.error;
    }
}

