/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.service;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.itextpdf.text.pdf.draw.LineSeparator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.ai.mcp.sample.server.tools.service.FacturaRequest;
import org.springframework.ai.mcp.sample.server.tools.service.FacturaResponse;
import org.springframework.ai.mcp.sample.server.tools.service.FacturaTool;
import org.springframework.ai.mcp.sample.server.tools.service.integration.EmailIntegrationService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FacturaToolService
implements FacturaTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacturaToolService.class);
    private final EmailIntegrationService emailIntegrationService;
    @Value(value="${path.pdf.factura}")
    private String facturaPath;
    @Value(value="${path.pdf.boleto}")
    private String boletoPath;

    @McpTool(description="Genera una factura comercial para Corporaci\u00f3n Aeroportuaria y la env\u00eda por correo electr\u00f3nico al cliente.")
    public FacturaResponse generarFactura(FacturaRequest request) {
        log.info("LOGICA MCP: Generando factura para {}", (Object)request.clientName());
        try {
            String logoB64 = "data:image/png;base64,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";
            Document document = new Document();
            try {
                String pdfBase64;
                Path path = Paths.get(this.facturaPath, new String[0]);
                if (path.getParent() != null) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.facturaPath));
                document.open();
                if (logoB64.contains(",")) {
                    String base64Image = logoB64.split(",")[1];
                    byte[] imageBytes = Base64.getDecoder().decode(base64Image);
                    Image logo = Image.getInstance((byte[])imageBytes);
                    logo.setAlignment(1);
                    logo.scaleAbsolute(150.0f, 50.0f);
                    document.add((Element)logo);
                }
                document.add((Element)new Paragraph("\n"));
                PdfPTable headerTable = new PdfPTable(2);
                headerTable.setWidthPercentage(100.0f);
                headerTable.setWidths(new float[]{1.0f, 1.0f});
                PdfPCell titleCell = new PdfPCell();
                titleCell.setBorder(0);
                Font titleFont = FontFactory.getFont((String)"Helvetica-Bold", (float)22.0f, (BaseColor)new BaseColor(0, 86, 179));
                titleCell.addElement((Element)new Paragraph("FACTURA", titleFont));
                titleCell.addElement((Element)new Paragraph("Corporaci\u00f3n Aeroportuaria", FontFactory.getFont((String)"Helvetica-Bold", (float)12.0f)));
                titleCell.addElement((Element)new Paragraph("RUC: 0190000000001", FontFactory.getFont((String)"Helvetica", (float)10.0f)));
                titleCell.addElement((Element)new Paragraph("Dir: Aeropuerto Internacional", FontFactory.getFont((String)"Helvetica", (float)10.0f)));
                headerTable.addCell(titleCell);
                PdfPCell infoCell = new PdfPCell();
                infoCell.setBorder(0);
                infoCell.setHorizontalAlignment(2);
                String invoiceNo = "001-001-" + String.format("%09d", System.currentTimeMillis() % 1000000000L);
                String fechaEmision = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
                Paragraph pNo = new Paragraph("No. " + invoiceNo, FontFactory.getFont((String)"Helvetica-Bold", (float)14.0f, (BaseColor)BaseColor.RED));
                pNo.setAlignment(2);
                infoCell.addElement((Element)pNo);
                Paragraph pFecha = new Paragraph("Fecha: " + fechaEmision, FontFactory.getFont((String)"Helvetica", (float)12.0f));
                pFecha.setAlignment(2);
                infoCell.addElement((Element)pFecha);
                headerTable.addCell(infoCell);
                document.add((Element)headerTable);
                document.add((Element)new Paragraph("\n"));
                LineSeparator line = new LineSeparator();
                line.setLineColor(new BaseColor(200, 200, 200));
                document.add((Element)new Chunk((DrawInterface)line));
                document.add((Element)new Paragraph("\n"));
                PdfPTable clientTable = new PdfPTable(1);
                clientTable.setWidthPercentage(100.0f);
                PdfPCell clientCell = new PdfPCell();
                clientCell.setBorder(0);
                Font labelFont = FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f, (BaseColor)BaseColor.DARK_GRAY);
                Font valFont = FontFactory.getFont((String)"Helvetica", (float)10.0f);
                clientCell.addElement((Element)new Paragraph("CLIENTE:", labelFont));
                clientCell.addElement((Element)new Paragraph(request.clientName().toUpperCase(), FontFactory.getFont((String)"Helvetica-Bold", (float)11.0f)));
                clientCell.addElement((Element)new Paragraph("RUC/CI: " + request.ruc(), valFont));
                clientCell.addElement((Element)new Paragraph("Direcci\u00f3n: " + request.direccion(), valFont));
                clientCell.addElement((Element)new Paragraph("Email: " + request.clientEmail(), valFont));
                clientTable.addCell(clientCell);
                document.add((Element)clientTable);
                document.add((Element)new Paragraph("\n"));
                PdfPTable table = new PdfPTable(2);
                table.setWidthPercentage(100.0f);
                table.setWidths(new float[]{4.0f, 1.0f});
                table.setSpacingBefore(10.0f);
                table.setSpacingAfter(10.0f);
                PdfPCell cellDesc = new PdfPCell(new Phrase("DESCRIPCI\u00d3N", FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f, (BaseColor)BaseColor.WHITE)));
                cellDesc.setBackgroundColor(new BaseColor(0, 86, 179));
                cellDesc.setPadding(8.0f);
                cellDesc.setBorderColor(BaseColor.LIGHT_GRAY);
                table.addCell(cellDesc);
                PdfPCell cellVal = new PdfPCell(new Phrase("VALOR", FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f, (BaseColor)BaseColor.WHITE)));
                cellVal.setBackgroundColor(new BaseColor(0, 86, 179));
                cellVal.setHorizontalAlignment(2);
                cellVal.setPadding(8.0f);
                cellVal.setBorderColor(BaseColor.LIGHT_GRAY);
                table.addCell(cellVal);
                if (request.items() != null) {
                    for (String item : request.items()) {
                        PdfPCell c1 = new PdfPCell(new Phrase(item, FontFactory.getFont((String)"Helvetica", (float)10.0f)));
                        c1.setPadding(6.0f);
                        c1.setBorderColor(BaseColor.LIGHT_GRAY);
                        table.addCell(c1);
                        PdfPCell c2 = new PdfPCell(new Phrase("-", FontFactory.getFont((String)"Helvetica", (float)10.0f)));
                        c2.setHorizontalAlignment(2);
                        c2.setPadding(6.0f);
                        c2.setBorderColor(BaseColor.LIGHT_GRAY);
                        table.addCell(c2);
                    }
                }
                double subtotal = request.total() / 1.15;
                double iva = request.total() - subtotal;
                this.addTotalRow(table, "SUBTOTAL", String.format("%.2f", request.total()), false);
                this.addTotalRow(table, "IVA 15%", "0.00", false);
                this.addTotalRow(table, "TOTAL A PAGAR", String.format("$ %.2f", request.total()), true);
                document.add((Element)table);
                document.add((Element)new Paragraph("\n"));
                Paragraph footer = new Paragraph("Gracias por su preferencia.\nEste documento no tiene validez tributaria (POC).", FontFactory.getFont((String)"Helvetica-Oblique", (float)9.0f, (BaseColor)BaseColor.GRAY));
                footer.setAlignment(1);
                document.add((Element)footer);
                document.close();
                log.info("FACTURA DEBUG: PDF generado con detalles y guardado en: {}", (Object)this.facturaPath);
                String html = "<html><body><h2>Factura Electr\u00f3nica</h2><p>Estimado " + request.clientName() + ",</p><p>Adjunto encontrar\u00e1 su factura por el valor de $" + request.total() + ".</p><p>Gracias por preferirnos.</p></body></html>";
                try {
                    pdfBase64 = this.base64(this.facturaPath);
                    log.info("FACTURA DEBUG: Base64 PDF le\u00eddo de disco, longitud: {}", (Object)pdfBase64.length());
                }
                catch (IOException e) {
                    log.error("FACTURA ERROR: Fallo al leer PDF de disco para Base64: {}", (Object)e.getMessage());
                    throw new RuntimeException("Error leyendo PDF de disco", e);
                }
                Map<String, String> archivoFactura = Map.of("fileName", "factura.pdf", "fileBase64", pdfBase64);
                ArrayList<Map<String, String>> attachments = new ArrayList<Map<String, String>>();
                attachments.add(archivoFactura);
                try {
                    String boletoBase64 = this.base64(this.boletoPath);
                    Map<String, String> archivoBoleto = Map.of("fileName", "boleto.pdf", "fileBase64", boletoBase64);
                    attachments.add(archivoBoleto);
                    log.info("FACTURA DEBUG: Boleto adjuntado correctamente.");
                }
                catch (Exception e) {
                    log.warn("FACTURA WARNING: No se pudo adjuntar el boleto (puede que no se haya generado aun): {}", (Object)e.getMessage());
                }
                log.info("FACTURA DEBUG: Enviando email con {} adjuntos", (Object)attachments.size());
                String response = this.emailIntegrationService.sendTicketEmail(request.clientName(), request.clientEmail(), "Factura Electr\u00f3nica y Boleto - Corporaci\u00f3n Aeroportuaria", html, attachments);
                return FacturaResponse.success((String)("Factura enviada: " + response), (String)("FAC-" + System.currentTimeMillis()));
            }
            catch (Exception e) {
                log.error("Error generando factura: {}", (Object)e.getMessage());
                return FacturaResponse.error((String)e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("Error generando factura: {}", (Object)e.getMessage());
            return FacturaResponse.error((String)e.getMessage());
        }
    }

    private void addTotalRow(PdfPTable table, String label, String value, boolean isTotal) {
        PdfPCell c1 = new PdfPCell(new Phrase(label, FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f)));
        c1.setHorizontalAlignment(2);
        c1.setPadding(6.0f);
        c1.setBorder(0);
        table.addCell(c1);
        PdfPCell c2 = new PdfPCell(new Phrase(value, FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f, (BaseColor)(isTotal ? BaseColor.BLACK : BaseColor.DARK_GRAY))));
        c2.setHorizontalAlignment(2);
        c2.setPadding(6.0f);
        c2.setBorderColor(BaseColor.LIGHT_GRAY);
        if (!isTotal) {
            c2.setBorder(2);
        }
        table.addCell(c2);
    }

    public String base64(String file) throws IOException {
        byte[] fileContent = Files.readAllBytes(Paths.get(file, new String[0]));
        String base64String = Base64.getEncoder().encodeToString(fileContent);
        return base64String;
    }

    @Generated
    public FacturaToolService(EmailIntegrationService emailIntegrationService) {
        this.emailIntegrationService = emailIntegrationService;
    }
}

