/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.service;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BarcodeQRCode;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.ai.mcp.sample.server.tools.service.BoletoRequest;
import org.springframework.ai.mcp.sample.server.tools.service.BoletoResponse;
import org.springframework.ai.mcp.sample.server.tools.service.EmailTool;
import org.springframework.ai.mcp.sample.server.tools.service.integration.EmailIntegrationService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EmailToolService
implements EmailTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailToolService.class);
    private final EmailIntegrationService emailIntegrationService;
    @Value(value="${path.pdf.boleto}")
    private String boletoPath;

    @McpTool(description="Emite un boleto a\u00e9reo para Corporaci\u00f3n Aeroportuaria y lo env\u00eda por correo electr\u00f3nico.")
    public BoletoResponse emitirBoleto(BoletoRequest request) {
        log.info("LOGICA MCP: Emitiendo boleto para {}", (Object)request.nombre());
        if (request.nombre() == null || request.nombre().isBlank() || request.email() == null || request.email().isBlank()) {
            return BoletoResponse.error((String)"Faltan datos obligatorios (nombre o email)");
        }
        String cleanEmail = request.email().trim().toLowerCase();
        try {
            String pdfBase64;
            Document document = new Document();
            try {
                Path path = Paths.get(this.boletoPath, new String[0]);
                if (path.getParent() != null) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.boletoPath));
                document.open();
                Font listTitleFont = FontFactory.getFont((String)"Helvetica-Bold", (float)18.0f, (BaseColor)new BaseColor(0, 100, 0));
                Paragraph mainTitle = new Paragraph("DETALLE DE VIAJE - " + request.nombre().toUpperCase(), listTitleFont);
                mainTitle.setAlignment(1);
                document.add((Element)mainTitle);
                document.add((Element)new Paragraph("\n"));
                this.addTicketSegment(document, "CUE", "UIO", "AV8548", "29 de Ene", "06:30", "07:15", "12A", request);
                document.add((Element)new Paragraph("\n"));
                document.add((Element)new Paragraph("-----------------------------------------------------------------------------"));
                document.add((Element)new Paragraph("\n"));
                this.addTicketSegment(document, "UIO", "CUE", "AV9650", "05 de Feb", "18:00", "18:45", "14F", request);
                document.add((Element)new Paragraph("\n"));
                Font linkFont = FontFactory.getFont((String)"Helvetica-Bold", (float)12.0f, (BaseColor)BaseColor.BLUE);
                Chunk chunk = new Chunk("Ver en App", linkFont);
                chunk.setAnchor("biocooppolicia://biocooppolicia.com?codigo=codetest");
                Paragraph linkPara = new Paragraph(chunk);
                linkPara.setAlignment(1);
                document.add((Element)linkPara);
                document.close();
                log.info("BOLETO DEBUG: PDF generado y guardado en: {}", (Object)this.boletoPath);
            }
            catch (Exception e) {
                log.error("BOLETO ERROR: Fallo generando PDF: {}", (Object)e.getMessage());
                throw new RuntimeException("Error creando PDF", e);
            }
            try {
                pdfBase64 = this.base64(this.boletoPath);
                log.info("BOLETO DEBUG: Base64 PDF le\u00eddo de disco, longitud: {}", (Object)pdfBase64.length());
            }
            catch (IOException e) {
                log.error("BOLETO ERROR: Fallo al leer PDF de disco: {}", (Object)e.getMessage());
                throw new RuntimeException("Error leyendo PDF", e);
            }
            Map<String, String> archivo = Map.of("fileName", "boleto.pdf", "fileBase64", pdfBase64);
            String response = this.emailIntegrationService.sendTicketEmail(request.nombre(), cleanEmail, "Tu Boleto A\u00e9reo: " + request.nombre(), "<html><body><p>Hola " + request.nombre() + ",</p><p>Adjuntamos tu boleto a\u00e9reo.</p><p>Gracias por viajar con nosotros.</p></body></html>", List.of(archivo));
            log.info("LOGICA MCP: Proceso de env\u00edo finalizado con respuesta: {}", (Object)response);
            return BoletoResponse.success((String)("Proceso completado: " + response), (String)("TX-" + System.currentTimeMillis()));
        }
        catch (Exception e) {
            log.error("Error al emitir boleto: {}", (Object)e.getMessage());
            return BoletoResponse.error((String)("Error al procesar el boleto: " + e.getMessage()));
        }
    }

    private void addTicketSegment(Document document, String origin, String dest, String flight, String date, String timeDep, String timeArr, String seat, BoletoRequest request) throws DocumentException {
        PdfPTable headerTable = new PdfPTable(3);
        headerTable.setWidthPercentage(100.0f);
        headerTable.setWidths(new float[]{3.0f, 3.0f, 4.0f});
        Font routeFont = FontFactory.getFont((String)"Helvetica-Bold", (float)22.0f);
        Font smallFont = FontFactory.getFont((String)"Helvetica", (float)10.0f);
        Font statusFont = FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f);
        Font valFont = FontFactory.getFont((String)"Helvetica", (float)12.0f);
        PdfPCell originCell = new PdfPCell((Phrase)new Paragraph(origin, routeFont));
        originCell.setBorder(0);
        headerTable.addCell(originCell);
        PdfPCell destCell = new PdfPCell((Phrase)new Paragraph(dest, routeFont));
        destCell.setBorder(0);
        headerTable.addCell(destCell);
        PdfPCell flightInfoCell = new PdfPCell();
        flightInfoCell.setBorder(0);
        flightInfoCell.addElement((Element)new Paragraph(flight, statusFont));
        flightInfoCell.addElement((Element)new Paragraph("A tiempo", smallFont));
        flightInfoCell.setHorizontalAlignment(2);
        headerTable.addCell(flightInfoCell);
        document.add((Element)headerTable);
        document.add((Element)new Paragraph("\n"));
        PdfPTable detailsTable = new PdfPTable(2);
        detailsTable.setWidthPercentage(100.0f);
        detailsTable.setWidths(new float[]{5.0f, 5.0f});
        detailsTable.addCell(this.getCellNoBorder("Fecha de salida", smallFont));
        detailsTable.addCell(this.getCellNoBorder("Fecha de llegada", smallFont));
        detailsTable.addCell(this.getCellNoBorder(date, valFont));
        detailsTable.addCell(this.getCellNoBorder(date, valFont));
        PdfPCell spacer = new PdfPCell((Phrase)new Paragraph(" "));
        spacer.setBorder(0);
        spacer.setColspan(2);
        detailsTable.addCell(spacer);
        detailsTable.addCell(this.getCellNoBorder("Salida", smallFont));
        detailsTable.addCell(this.getCellNoBorder("Hora de llegada", smallFont));
        detailsTable.addCell(this.getCellNoBorder(timeDep, valFont));
        detailsTable.addCell(this.getCellNoBorder(timeArr, valFont));
        document.add((Element)detailsTable);
        document.add((Element)new Paragraph("\n"));
        PdfPTable passengerTable = new PdfPTable(3);
        passengerTable.setWidthPercentage(100.0f);
        passengerTable.setWidths(new float[]{6.0f, 2.0f, 2.0f});
        passengerTable.addCell(this.getCellNoBorder("Pasajero", smallFont));
        passengerTable.addCell(this.getCellNoBorder("Grupo", smallFont));
        passengerTable.addCell(this.getCellNoBorder("Asiento", smallFont));
        passengerTable.addCell(this.getCellNoBorder(request.nombre().toUpperCase(), valFont));
        passengerTable.addCell(this.getCellNoBorder("C", valFont));
        passengerTable.addCell(this.getCellNoBorder(seat, valFont));
        document.add((Element)passengerTable);
        document.add((Element)new Paragraph("\n"));
        try {
            String qrContent = "BOLETO:" + request.nombre() + ":" + origin + "-" + dest + ":" + flight;
            BarcodeQRCode barcodeQRCode = new BarcodeQRCode(qrContent, 1000, 1000, null);
            Image codeQrImage = barcodeQRCode.getImage();
            codeQrImage.scaleAbsolute(80.0f, 80.0f);
            codeQrImage.setAlignment(1);
            document.add((Element)codeQrImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PdfPCell getCellNoBorder(String text, Font font) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(text, font));
        cell.setBorder(0);
        return cell;
    }

    public String base64(String file) throws IOException {
        byte[] fileContent = Files.readAllBytes(Paths.get(file, new String[0]));
        String base64String = Base64.getEncoder().encodeToString(fileContent);
        return base64String;
    }

    @Generated
    public EmailToolService(EmailIntegrationService emailIntegrationService) {
        this.emailIntegrationService = emailIntegrationService;
    }
}

