/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.ai.mcp.sample.server.models.VuelosFechaHoraRequest;
import org.springframework.ai.mcp.sample.server.tools.service.AeroPuertoTool;
import org.springframework.ai.mcp.sample.server.tools.service.ArribosRequest;
import org.springframework.ai.mcp.sample.server.tools.service.ArribosResponse;
import org.springframework.ai.mcp.sample.server.tools.service.BuscarVueloRequest;
import org.springframework.ai.mcp.sample.server.tools.service.ItinerarioRequest;
import org.springframework.ai.mcp.sample.server.tools.service.ItinerarioResponse;
import org.springframework.ai.mcp.sample.server.tools.service.SalidasRequest;
import org.springframework.ai.mcp.sample.server.tools.service.SalidasResponse;
import org.springframework.ai.mcp.sample.server.tools.service.Vuelo;
import org.springframework.ai.mcp.sample.server.tools.service.VueloDetalleResponse;
import org.springframework.ai.mcp.sample.server.tools.service.VuelosFechaHoraResponse;
import org.springframework.ai.mcp.sample.server.tools.service.integration.FlightIntegrationService;
import org.springframework.stereotype.Service;

@Service
public class AeropuertoToolService
implements AeroPuertoTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AeropuertoToolService.class);
    private final FlightIntegrationService flightIntegrationService;
    private final ObjectMapper objectMapper;

    @McpTool(description="Busca vuelos por fecha y hora")
    public VuelosFechaHoraResponse buscarPorFechaHora(VuelosFechaHoraRequest request) {
        if (request == null) {
            return VuelosFechaHoraResponse.error((String)"Faltan par\u00e1metros de fecha y hora");
        }
        log.info("LOGICA MCP: Buscando vuelos por fecha {} entre {} y {}", new Object[]{request.fecha(), request.horaInicio(), request.horaFin()});
        try {
            List arribos = this.fetchArribos();
            List salidas = this.fetchSalidas();
            ArrayList todos = new ArrayList();
            if (arribos != null) {
                todos.addAll(arribos);
            }
            if (salidas != null) {
                todos.addAll(salidas);
            }
            if (todos.isEmpty()) {
                return VuelosFechaHoraResponse.error((String)"No se pudo obtener informaci\u00f3n del aeropuerto");
            }
            LocalDate fechaFiltro = LocalDate.parse(request.fecha());
            LocalTime inicio = LocalTime.parse(request.horaInicio());
            LocalTime fin = LocalTime.parse(request.horaFin());
            List filtrados = todos.stream().filter(v -> {
                try {
                    LocalDate fechaVuelo = LocalDate.parse(v.fecha());
                    LocalTime horaVuelo = LocalTime.parse(v.hora());
                    return !(!fechaVuelo.equals(fechaFiltro) || !horaVuelo.isAfter(inicio) && !horaVuelo.equals(inicio) || !horaVuelo.isBefore(fin) && !horaVuelo.equals(fin));
                }
                catch (Exception e) {
                    log.warn("Fecha u hora inv\u00e1lida en vuelo: {}", v);
                    return false;
                }
            }).collect(Collectors.toList());
            log.info("LOGICA MCP: Vuelos encontrados: {}", (Object)filtrados.size());
            return VuelosFechaHoraResponse.ok(filtrados, (int)filtrados.size());
        }
        catch (Exception e) {
            log.error("Error al buscar por fecha/hora: {}", (Object)e.getMessage());
            return VuelosFechaHoraResponse.error((String)("Error: " + e.getMessage()));
        }
    }

    @McpTool(description="Obtiene todos los vuelos de salida y arribo del aeropuerto de Cuenca en tiempo real")
    public ItinerarioResponse getItinerarios(ItinerarioRequest request) {
        log.info("LOGICA MCP: Obteniendo itinerarios completos del aeropuerto");
        try {
            List arribos = this.fetchArribos();
            List salidas = this.fetchSalidas();
            if (arribos == null && salidas == null) {
                return ItinerarioResponse.error((String)"No se pudo conectar con el aeropuerto");
            }
            arribos = arribos != null ? arribos : new ArrayList();
            salidas = salidas != null ? salidas : new ArrayList();
            log.info("LOGICA MCP: Itinerarios obtenidos. Salidas: {}, Arribos: {}", (Object)salidas.size(), (Object)arribos.size());
            return ItinerarioResponse.success((String)"Aeropuerto Mariscal La Mar - API Externa", (List)salidas, (List)arribos, (int)salidas.size(), (int)arribos.size());
        }
        catch (Exception e) {
            log.error("Error inesperado: {}", (Object)e.getMessage(), (Object)e);
            return ItinerarioResponse.error((String)("Error inesperado: " + e.getMessage()));
        }
    }

    @McpTool(description="Busca un vuelo espec\u00edfico por su n\u00famero (ej: AV 1605, LA 1386)")
    public VueloDetalleResponse buscarPorNumeroVuelo(BuscarVueloRequest request) {
        if (request == null || request.numeroVuelo() == null) {
            return VueloDetalleResponse.notFound((String)"No especificado");
        }
        log.info("LOGICA MCP: Buscando vuelo: {}", (Object)request.numeroVuelo());
        try {
            Vuelo vueloEncontrado;
            List arribos = this.fetchArribos();
            List salidas = this.fetchSalidas();
            ArrayList todosVuelos = new ArrayList();
            if (arribos != null) {
                todosVuelos.addAll(arribos);
            }
            if (salidas != null) {
                todosVuelos.addAll(salidas);
            }
            if ((vueloEncontrado = (Vuelo)todosVuelos.stream().filter(v -> v.vuelo().equalsIgnoreCase(request.numeroVuelo().trim())).findFirst().orElse(null)) != null) {
                log.info("LOGICA MCP: Vuelo encontrado: {}", (Object)vueloEncontrado.vuelo());
                return VueloDetalleResponse.found((Vuelo)vueloEncontrado);
            }
            log.info("LOGICA MCP: Vuelo no encontrado: {}. Sugiriendo similares.", (Object)request.numeroVuelo());
            List sugerencias = todosVuelos.stream().filter(v -> v.vuelo().toLowerCase().contains(request.numeroVuelo().toLowerCase().trim())).limit(5L).collect(Collectors.toList());
            String msg = "No se encontr\u00f3 el vuelo " + request.numeroVuelo() + ". ";
            msg = !sugerencias.isEmpty() ? msg + "Quiz\u00e1s quisiste decir alguno de estos: " + sugerencias.stream().map(Vuelo::vuelo).collect(Collectors.joining(", ")) : msg + "Intenta consultar todos los itinerarios para ver los vuelos disponibles.";
            return new VueloDetalleResponse(null, false, msg);
        }
        catch (Exception e) {
            log.error("Error al buscar vuelo: {}", (Object)e.getMessage(), (Object)e);
            return VueloDetalleResponse.notFound((String)request.numeroVuelo());
        }
    }

    @McpTool(description="Obtiene solo los vuelos de salida del aeropuerto, opcionalmente filtrados por aerol\u00ednea")
    public SalidasResponse getSalidas(SalidasRequest request) {
        String aerolinea = request != null ? request.aerolinea() : null;
        log.info("LOGICA MCP: Obteniendo salidas. Filtro aerol\u00ednea: {}", (Object)aerolinea);
        try {
            List salidas = this.fetchSalidas();
            if (salidas == null) {
                return new SalidasResponse(List.of(), 0, "Error al obtener datos");
            }
            if (aerolinea != null && !aerolinea.isBlank()) {
                salidas = salidas.stream().filter(v -> v.aerolinea().toLowerCase().contains(aerolinea.toLowerCase())).collect(Collectors.toList());
                log.info("LOGICA MCP: Salidas filtradas por {}: {} resultados", (Object)aerolinea, (Object)salidas.size());
                return new SalidasResponse(salidas, salidas.size(), "Filtrado por aerol\u00ednea: " + aerolinea);
            }
            log.info("LOGICA MCP: Total de salidas: {}", (Object)salidas.size());
            return new SalidasResponse(salidas, salidas.size(), "Sin filtros");
        }
        catch (Exception e) {
            log.error("Error al obtener salidas: {}", (Object)e.getMessage(), (Object)e);
            return new SalidasResponse(List.of(), 0, "Error: " + e.getMessage());
        }
    }

    @McpTool(description="Obtiene solo los vuelos de arribo al aeropuerto, opcionalmente filtrados por aerol\u00ednea")
    public ArribosResponse getArribos(ArribosRequest request) {
        String aerolinea = request != null ? request.aerolinea() : null;
        log.info("LOGICA MCP: Obteniendo arribos. Filtro aerol\u00ednea: {}", (Object)aerolinea);
        try {
            List arribos = this.fetchArribos();
            if (arribos == null) {
                return new ArribosResponse(List.of(), 0, "Error al obtener datos");
            }
            if (aerolinea != null && !aerolinea.isBlank()) {
                arribos = arribos.stream().filter(v -> v.aerolinea().toLowerCase().contains(aerolinea.toLowerCase())).collect(Collectors.toList());
                log.info("LOGICA MCP: Arribos filtrados por {}: {} resultados", (Object)aerolinea, (Object)arribos.size());
                return new ArribosResponse(arribos, arribos.size(), "Filtrado por aerol\u00ednea: " + aerolinea);
            }
            log.info("LOGICA MCP: Total de arribos: {}", (Object)arribos.size());
            return new ArribosResponse(arribos, arribos.size(), "Sin filtros");
        }
        catch (Exception e) {
            log.error("Error al obtener arribos: {}", (Object)e.getMessage(), (Object)e);
            return new ArribosResponse(List.of(), 0, "Error: " + e.getMessage());
        }
    }

    private List<Vuelo> fetchArribos() {
        try {
            String json = this.flightIntegrationService.getArribos();
            if (json == null || json.contains("Error")) {
                log.warn("Fetch arribos failed with message: {}", (Object)json);
                return null;
            }
            log.info("Parsing arribos JSON (length: {})", (Object)json.length());
            List result = (List)this.objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            log.info("Parsed {} arribos", (Object)(result != null ? result.size() : 0));
            return result;
        }
        catch (Exception e) {
            log.error("Error parseando arribos: {}", (Object)e.getMessage());
            return null;
        }
    }

    private List<Vuelo> fetchSalidas() {
        try {
            String json = this.flightIntegrationService.getSalidas();
            if (json == null || json.contains("Error")) {
                log.warn("Fetch salidas failed with message: {}", (Object)json);
                return null;
            }
            log.info("Parsing salidas JSON (length: {})", (Object)json.length());
            List result = (List)this.objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            log.info("Parsed {} salidas", (Object)(result != null ? result.size() : 0));
            return result;
        }
        catch (Exception e) {
            log.error("Error parseando salidas: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Generated
    public AeropuertoToolService(FlightIntegrationService flightIntegrationService, ObjectMapper objectMapper) {
        this.flightIntegrationService = flightIntegrationService;
        this.objectMapper = objectMapper;
    }
}

