/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server;

import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.ai.mcp.sample.server.McpServerApplication;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class McpServerApplication {
    public static void main(String[] args) {
        SpringApplication.run(McpServerApplication.class, (String[])args);
    }

    @Bean
    public ToolCallback toUpperCase() {
        return FunctionToolCallback.builder((String)"toUpperCase", input -> input.input().toUpperCase()).inputType(TextInput.class).description("Put the text to upper case").build();
    }

    @Bean
    public CommandLineRunner logTools(ApplicationContext ctx) {
        return args -> {
            System.out.println("========== MCP TOOLS DIAGNOSTIC ==========");
            CharSequence[] mcpToolBeans = ctx.getBeanNamesForAnnotation(McpTool.class);
            System.out.println("Beans con @McpTool encontrados: " + String.join((CharSequence)", ", mcpToolBeans));
            CharSequence[] toolCallbacks = ctx.getBeanNamesForType(ToolCallback.class);
            System.out.println("Callbacks de herramientas registrados: " + String.join((CharSequence)", ", toolCallbacks));
            System.out.println("==========================================");
        };
    }
}

