/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_cpn_api.infrastructure.service.impl;

import com.lhia.client.api.lhia_cpn_api.infrastructure.entity.TFileContentEntity;
import com.lhia.client.api.lhia_cpn_api.infrastructure.repository.TFileContentRepository;
import com.lhia.client.api.lhia_cpn_api.infrastructure.service.FileContentService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class FileContentServiceImpl
implements FileContentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileContentServiceImpl.class);
    private final TFileContentRepository fileContentRepository;

    public void deleteById(UUID fileId) {
        this.fileContentRepository.deleteById((Object)fileId);
    }

    public TFileContentEntity save(TFileContentEntity entity) {
        return (TFileContentEntity)this.fileContentRepository.save((Object)entity);
    }

    public ResponseEntity<byte[]> getByteFileById(UUID fileId) {
        log.info("Solicitud de descarga de archivo con ID {}", (Object)fileId);
        Optional documentFile = this.fileContentRepository.findById((Object)fileId);
        if (documentFile.isPresent()) {
            String mimeType;
            TFileContentEntity fileEntity = (TFileContentEntity)documentFile.get();
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(fileEntity.getFileData());){
                    mimeType = URLConnection.guessContentTypeFromStream(is);
                    log.debug("Tipo MIME detectado para {}: {}", (Object)fileId, (Object)mimeType);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error("Error al leer stream para detecci\u00f3n de MIME de archivo {}", (Object)fileId, (Object)e);
                mimeType = null;
            }
            if (mimeType == null) {
                mimeType = "application/octet-stream";
                log.warn("No se pudo detectar MIME para {}, usando {}", (Object)fileId, (Object)mimeType);
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)mimeType));
            log.info("Enviando archivo {} con Content-Type={}", (Object)fileId, (Object)mimeType);
            return new ResponseEntity((Object)fileEntity.getFileData(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        log.warn("Archivo no encontrado para ID {}", (Object)fileId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Generated
    public FileContentServiceImpl(TFileContentRepository fileContentRepository) {
        this.fileContentRepository = fileContentRepository;
    }
}

