/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_cpn_api.common.interceptors;

import com.lhia.client.api.lhia_cpn_api.common.exceptions.AnalysisPersistenceException;
import com.lhia.client.api.lhia_cpn_api.common.exceptions.DuplicateReferenceFormException;
import com.lhia.client.api.lhia_cpn_api.common.exceptions.InvalidImageException;
import com.lhia.client.api.lhia_cpn_api.common.exceptions.PdfConversionException;
import com.lhia.client.api.lhia_cpn_api.common.exceptions.ResourceNotFoundException;
import com.lhia.client.api.lhia_cpn_api.common.exceptions.SinglePagePdfRequiredException;
import com.lhia.client.api.lhia_cpn_api.common.exceptions.ValidationException;
import com.lhia.client.api.lhia_cpn_api.config.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.resource.NoResourceFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<ApiResponse<Object>> handleValidationException(ValidationException ex) {
        log.warn("Fallo de validaci\u00f3n: {}", (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.VALIDATION_ERROR, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={AnalysisPersistenceException.class})
    public ResponseEntity<ApiResponse<Object>> handleAnalysisPersistence(AnalysisPersistenceException ex) {
        log.warn("Fall\u00f3 persistencia de an\u00e1lisis: {}", (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)ApiResponse.error((int)HttpStatus.CONFLICT.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.ERROR, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={InvalidImageException.class})
    public ResponseEntity<ApiResponse<Object>> handleInvalidImage(InvalidImageException ex) {
        log.warn("Archivo no es imagen v\u00e1lida: {}", (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.VALIDATION_ERROR, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={PdfConversionException.class})
    public ResponseEntity<ApiResponse<Object>> handlePdfConversion(PdfConversionException ex) {
        log.warn("Error de conversi\u00f3n de PDF: {}", (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.VALIDATION_ERROR, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={SinglePagePdfRequiredException.class})
    public ResponseEntity<ApiResponse<Object>> handlePdfPageError(SinglePagePdfRequiredException ex) {
        log.warn("PDF inv\u00e1lido: {}", (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.VALIDATION_ERROR, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResponseEntity<ApiResponse<Object>> handleResourceNotFound(ResourceNotFoundException ex) {
        log.warn("Recurso no encontrado: {}", (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((int)HttpStatus.NOT_FOUND.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.RESOURCE_NOT_FOUND, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={DuplicateReferenceFormException.class})
    public ResponseEntity<ApiResponse<Object>> handleDuplicateReference(DuplicateReferenceFormException ex) {
        String msg = ex.getMessage();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)ApiResponse.error((int)HttpStatus.CONFLICT.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.DUPLICATE_REFERENCE_FORM, (String)msg));
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseEntity<ApiResponse<Object>> handleDuplicateKey(DataIntegrityViolationException ex) {
        String detail = ex.getMostSpecificCause().getMessage();
        String msg = "La referencia ya existe en el sistema: " + detail;
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)ApiResponse.error((int)HttpStatus.CONFLICT.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.DUPLICATE_REFERENCE_FORM, (String)msg));
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ApiResponse<Object>> handleBadRequest(IllegalArgumentException ex) {
        String msg = "BadRequest: La referencia ya existe en el sistema: " + ex.getMessage();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((int)HttpStatus.BAD_REQUEST.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.BAD_REQUEST, (String)msg));
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<ApiResponse<Object>> handleNoHandler(NoHandlerFoundException ex) {
        String path = ex.getRequestURL();
        String msg = "Ruta no encontrada: " + path;
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((int)HttpStatus.NOT_FOUND.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.NOT_FOUND, (String)msg));
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    public ResponseEntity<ApiResponse<Object>> handleNoResource(NoResourceFoundException ex, HttpServletRequest req) {
        String uri = req.getRequestURI();
        String msg = "Recurso est\u00e1tico no encontrado: " + uri;
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((int)HttpStatus.NOT_FOUND.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.NOT_FOUND, (String)msg));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<ApiResponse<Object>> handleMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpServletRequest req) {
        String uri = req.getRequestURI();
        String msg = "M\u00e9todo no permitido para: " + uri;
        return ResponseEntity.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).body((Object)ApiResponse.error((int)405, (ApiResponse.ResponseCode)ApiResponse.ResponseCode.METHOD_NOT_ALLOWED, (String)msg));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ApiResponse<?>> handleValidation(MethodArgumentNotValidException ex) {
        ArrayList details = new ArrayList();
        ex.getBindingResult().getFieldErrors().forEach(fe -> {
            boolean bl = details.add(Map.of("field", fe.getField(), "message", fe.getDefaultMessage()));
        });
        ex.getBindingResult().getGlobalErrors().forEach(ge -> {
            boolean bl = details.add(Map.of("field", ge.getObjectName(), "message", ge.getDefaultMessage()));
        });
        return ResponseEntity.badRequest().body((Object)ApiResponse.error((int)400, (ApiResponse.ResponseCode)ApiResponse.ResponseCode.VALIDATION_ERROR, (String)"Error de validaci\u00f3n de entrada: campos inv\u00e1lidos o faltantes.", Map.of("details", details)));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ApiResponse<Object>> handleBadJson(HttpMessageNotReadableException ex) {
        return ResponseEntity.badRequest().body((Object)ApiResponse.error((int)400, (ApiResponse.ResponseCode)ApiResponse.ResponseCode.VALIDATION_ERROR, (String)"JSON inv\u00e1lido o no legible"));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ApiResponse<Object>> handleGeneric(Exception ex) {
        log.error("Error no controlado en la petici\u00f3n", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((int)500, (ApiResponse.ResponseCode)ApiResponse.ResponseCode.ERROR, (String)"Error interno del servidor"));
    }
}

