/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_cpn_api.auth;

import com.lhia.client.api.lhia_cpn_api.auth.JwtAuthConverter;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    private static final String[] WHITELIST = new String[]{"/swagger-ui.html", "/swagger-ui/**", "/v3/api-docs/**", "/v3/api-docs.yaml", "/swagger-resources/**", "/webjars/**", "/file-content/**"};
    private final JwtAuthConverter jwtAuthConverter;
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final AccessDeniedHandler accessDeniedHandler;

    public WebSecurityConfig(JwtAuthConverter jwtAuthConverter, AuthenticationEntryPoint authenticationEntryPoint, AccessDeniedHandler accessDeniedHandler) {
        this.jwtAuthConverter = jwtAuthConverter;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.accessDeniedHandler = accessDeniedHandler;
    }

    @Bean
    @Order(value=-2147483648)
    public SecurityFilterChain swaggerChain(HttpSecurity http) throws Exception {
        OrRequestMatcher swaggerMatcher = new OrRequestMatcher(Arrays.stream(WHITELIST).map(AntPathRequestMatcher::new).collect(Collectors.toList()));
        http.securityMatcher((RequestMatcher)swaggerMatcher).csrf(csrf -> {
            HttpSecurityBuilder httpSecurityBuilder = csrf.disable();
        }).authorizeHttpRequests(auth -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll();
        }).sessionManagement(sm -> {
            SessionManagementConfigurer sessionManagementConfigurer = sm.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        });
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public SecurityFilterChain apiChain(HttpSecurity http) throws Exception {
        http.csrf(csrf -> {
            HttpSecurityBuilder httpSecurityBuilder = csrf.disable();
        }).cors(cors -> {}).sessionManagement(sm -> {
            SessionManagementConfigurer sessionManagementConfigurer = sm.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }).exceptionHandling(ex -> {
            ExceptionHandlingConfigurer exceptionHandlingConfigurer = ex.authenticationEntryPoint(this.authenticationEntryPoint).accessDeniedHandler(this.accessDeniedHandler);
        }).authorizeHttpRequests(auth -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().anyRequest()).authenticated();
        }).oauth2ResourceServer(oauth2 -> {
            OAuth2ResourceServerConfigurer oAuth2ResourceServerConfigurer = oauth2.authenticationEntryPoint(this.authenticationEntryPoint).accessDeniedHandler(this.accessDeniedHandler).jwt(jwt -> {
                OAuth2ResourceServerConfigurer.JwtConfigurer jwtConfigurer = jwt.jwtAuthenticationConverter((Converter)this.jwtAuthConverter);
            });
        });
        return (SecurityFilterChain)http.build();
    }
}

