/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_cpn_api.auth;

import com.lhia.client.api.lhia_cpn_api.auth.JwtAuthConverterProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private final JwtAuthConverterProperties properties;

    public JwtAuthConverter(JwtAuthConverterProperties properties) {
        this.properties = properties;
    }

    public AbstractAuthenticationToken convert(@NonNull Jwt jwt) {
        Collection authorities = this.extractResourceRoles(jwt);
        return new JwtAuthenticationToken(jwt, authorities, this.getPrincipalClaimName(jwt));
    }

    private String getPrincipalClaimName(Jwt jwt) {
        String claimName = "sub";
        if (this.properties.getPrincipalAttribute() != null) {
            claimName = this.properties.getPrincipalAttribute();
        }
        return (String)jwt.getClaim(claimName);
    }

    private Collection<GrantedAuthority> extractResourceRoles(Jwt jwt) {
        Map realmAccess = (Map)jwt.getClaim("realm_access");
        if (realmAccess == null || realmAccess.get("roles") == null) {
            return Collections.emptySet();
        }
        Object roles = realmAccess.get("roles");
        if (roles instanceof Collection) {
            Collection resourceRoles = (Collection)roles;
            return resourceRoles.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role.toUpperCase())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

