/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_cpn_api.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lhia.client.api.lhia_cpn_api.config.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.context.annotation.Primary;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
@Primary
public class JsonAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private final ObjectMapper mapper;

    public JsonAuthenticationEntryPoint(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        ApiResponse apiError = ApiResponse.error((int)401, (ApiResponse.ResponseCode)ApiResponse.ResponseCode.UNAUTHORIZED, (String)"No autorizado");
        response.setStatus(401);
        response.setContentType("application/json;charset=UTF-8");
        String body = this.mapper.writeValueAsString((Object)apiError);
        response.getWriter().write(body);
    }
}

